/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.filehosting.api.IFileHosting.
 */

goog.provide('net.bluemind.filehosting.api.FileHostingVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.filehosting.api.IFileHosting API.
 * @param {string sessionId} sessionId
*  @param {string} domainUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.filehosting.api.FileHostingVertxClient = function( sessionId , domainUid ) {
  this.sessionId = sessionId;
  this.base = '/filehosting/{domainUid}';
  this.domainUid_ = domainUid;
  this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
};

goog.inherits(net.bluemind.filehosting.api.FileHostingVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.filehosting.api.FileHostingVertxClient.prototype.domainUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingVertxClient.prototype.delete_ = function( path  ) {

  var postUri = "/{path}";

  postUri = postUri.replace("{path}", goog.string.urlEncode(path));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingVertxClient.prototype.exists = function( path  ) {

  var postUri = "/{path}/_exists";

  postUri = postUri.replace("{path}", goog.string.urlEncode(path));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} query
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingVertxClient.prototype.find = function( query  ) {

  var postUri = "/_find";

  var params = {};

  if (goog.isDefAndNotNull(query)) {
    params['query'] = query;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingVertxClient.prototype.get = function( path  ) {

  var postUri = "/{path}/_content";

  postUri = postUri.replace("{path}", goog.string.urlEncode(path));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingVertxClient.prototype.getConfiguration = function() {

  var postUri = "/_config";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingVertxClient.prototype.info = function() {

  var postUri = "/_info";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingVertxClient.prototype.list = function( path  ) {

  var postUri = "/_list";

  var params = {};

  if (goog.isDefAndNotNull(path)) {
    params['path'] = path;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @param {number} downloadLimit
 * @param {string} expirationDate
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingVertxClient.prototype.share = function( path ,  downloadLimit ,  expirationDate  ) {

  var postUri = "/_share";

  var params = {};

  if (goog.isDefAndNotNull(path)) {
    params['path'] = path;
  }
  if (goog.isDefAndNotNull(downloadLimit)) {
    params['downloadLimit'] = downloadLimit;
  }
  if (goog.isDefAndNotNull(expirationDate)) {
    params['expirationDate'] = expirationDate;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @param {stream} document
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingVertxClient.prototype.store = function( path ,  document  ) {

  var postUri = "/{path}";

  postUri = postUri.replace("{path}", goog.string.urlEncode(path));
  var params = {};



  var body = null;
  body = document;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @param {number} downloadLimit
 * @param {string} expirationDate
 * @param {stream} document
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingVertxClient.prototype.storeAndShare = function( path ,  downloadLimit ,  expirationDate ,  document  ) {

  var postUri = "/_store_share";

  var params = {};

  if (goog.isDefAndNotNull(path)) {
    params['path'] = path;
  }
  if (goog.isDefAndNotNull(downloadLimit)) {
    params['downloadLimit'] = downloadLimit;
  }
  if (goog.isDefAndNotNull(expirationDate)) {
    params['expirationDate'] = expirationDate;
  }


  var body = null;
  body = document;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} url
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingVertxClient.prototype.unShare = function( url  ) {

  var postUri = "/{url}/unshare";

  postUri = postUri.replace("{url}", goog.string.urlEncode(url));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

