/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.filehosting.api.IFileHosting.
 */

goog.provide('net.bluemind.filehosting.api.FileHostingClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.filehosting.api.IFileHosting API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} domainUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.filehosting.api.FileHostingClient = function(rpc, base , domainUid ) {
  goog.base(this, rpc, base);
  this.base += '/filehosting/{domainUid}';
   this.domainUid_ = domainUid;
   this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
};

goog.inherits(net.bluemind.filehosting.api.FileHostingClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.filehosting.api.FileHostingClient.prototype.domainUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingClient.prototype.delete_ = function( path  ) {

  var postUri = "/{path}";

  postUri = postUri.replace("{path}", goog.string.urlEncode(path));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "delete_" 
                                  + this.domainUid_
                                  + path
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingClient.prototype.exists = function( path  ) {

  var postUri = "/{path}/_exists";

  postUri = postUri.replace("{path}", goog.string.urlEncode(path));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "exists_" 
                                  + this.domainUid_
                                  + path
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} query
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingClient.prototype.find = function( query  ) {

  var postUri = "/_find";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(query)) {
    url.getQueryData().add('query', query);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "find_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingClient.prototype.get = function( path  ) {

  var postUri = "/{path}/_content";

  postUri = postUri.replace("{path}", goog.string.urlEncode(path));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "get_" 
                                  + this.domainUid_
                                  + path
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingClient.prototype.getConfiguration = function() {

  var postUri = "/_config";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getConfiguration_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingClient.prototype.info = function() {

  var postUri = "/_info";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "info_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingClient.prototype.list = function( path  ) {

  var postUri = "/_list";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(path)) {
    url.getQueryData().add('path', path);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "list_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @param {number} downloadLimit
 * @param {string} expirationDate
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingClient.prototype.share = function( path ,  downloadLimit ,  expirationDate  ) {

  var postUri = "/_share";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(path)) {
    url.getQueryData().add('path', path);
  }
  if (goog.isDefAndNotNull(downloadLimit)) {
    url.getQueryData().add('downloadLimit', downloadLimit);
  }
  if (goog.isDefAndNotNull(expirationDate)) {
    url.getQueryData().add('expirationDate', expirationDate);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "share_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @param {stream} document
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingClient.prototype.store = function( path ,  document  ) {

  var postUri = "/{path}";

  postUri = postUri.replace("{path}", goog.string.urlEncode(path));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "store_" 
                                  + this.domainUid_
                                  + path
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = document;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @param {number} downloadLimit
 * @param {string} expirationDate
 * @param {stream} document
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingClient.prototype.storeAndShare = function( path ,  downloadLimit ,  expirationDate ,  document  ) {

  var postUri = "/_store_share";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(path)) {
    url.getQueryData().add('path', path);
  }
  if (goog.isDefAndNotNull(downloadLimit)) {
    url.getQueryData().add('downloadLimit', downloadLimit);
  }
  if (goog.isDefAndNotNull(expirationDate)) {
    url.getQueryData().add('expirationDate', expirationDate);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "storeAndShare_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = document;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} url
 * @return {Object}
 */
net.bluemind.filehosting.api.FileHostingClient.prototype.unShare = function( url  ) {

  var postUri = "/{url}/unshare";

  postUri = postUri.replace("{url}", goog.string.urlEncode(url));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "unShare_" 
                                  + this.domainUid_
                                  + url
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

