package net.bluemind.exchange.mapi.service.internal;

import java.util.List;
import java.util.UUID;

import net.bluemind.core.rest.BmContext;
import net.bluemind.exchange.mapi.api.IMapiPCLCache;
import net.bluemind.exchange.mapi.api.MapiPCLCacheEntry;
import net.bluemind.exchange.mapi.hook.IMapiPCLCacheHook;
import net.bluemind.exchange.mapi.hook.MapiPCLCacheHook;
import net.bluemind.exchange.mapi.repository.IMapiPCLCacheStore;
import net.bluemind.repository.provider.RepositoryProvider;

public class MapiPCLCache implements IMapiPCLCache {

	private IMapiPCLCacheStore store;
	private List<IMapiPCLCacheHook> hooks;

	public MapiPCLCache(BmContext context) {
		store = RepositoryProvider.instance(IMapiPCLCacheStore.class, context);
		hooks = MapiPCLCacheHook.get();
	}

	@Override
	public MapiPCLCacheEntry get(String replicaGuid, Long globalCounter) {
		return store.get(UUID.fromString(replicaGuid), globalCounter);
	}

	@Override
	public void store(String replicaGuid, Long globalCounter, MapiPCLCacheEntry entry) {
		store.store(UUID.fromString(replicaGuid), globalCounter, entry);
		hooks.forEach(hook -> hook.postSave(replicaGuid, globalCounter, entry));
	}

	@Override
	public boolean contains(String replicaGuid, Long globalCounter) {
		return store.contains(UUID.fromString(replicaGuid), globalCounter);
	}

	@Override
	public void delete(String replicaGuid, Long globalCounter) {
		store.delete(UUID.fromString(replicaGuid), globalCounter);
		hooks.forEach(hook -> hook.postDelete(replicaGuid, globalCounter));
	}

}
