package net.bluemind.exchange.mapi.persistence.pclcache;

import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Verticle;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.lib.vertx.IUniqueVerticleFactory;
import net.bluemind.lib.vertx.IVerticleFactory;
import net.bluemind.lib.vertx.VertxPlatform;
import net.bluemind.system.api.SystemState;
import net.bluemind.system.state.StateContext;

public class CleanPclOrphanVerticle extends AbstractVerticle {
	private static final Logger logger = LoggerFactory.getLogger(CleanPclOrphanVerticle.class);

	private final long nbMilliSecondsTimer;

	private MapiPCLCacheStore pclStore;

	private BmContext bmContext;

	public CleanPclOrphanVerticle() {
		this(TimeUnit.MINUTES.toMillis(5));
	}

	public CleanPclOrphanVerticle(long nbMilliSecondsTimer) {
		this.nbMilliSecondsTimer = nbMilliSecondsTimer;
		bmContext = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM).getContext();
	}

	@Override
	public void start() throws Exception {
		vertx.setTimer(nbMilliSecondsTimer, ev -> {
			this.execute(ev);
			VertxPlatform.executeBlockingPeriodic(vertx, nbMilliSecondsTimer, this::execute);
		});
	}

	private MapiPCLCacheStore getCacheStore() {
		if (pclStore == null) {
			pclStore = new MapiPCLCacheStore(bmContext.getAllMailboxDataSource().getFirst());
		}
		return pclStore;
	}

	private void execute(Long timerId) {
		if (StateContext.getState() != SystemState.CORE_STATE_RUNNING) {
			return;
		}

		vertx.executeBlocking(() -> {
			logger.info("Start clean orphans");
			long nbDeleted = getCacheStore().cleanOrphan();
			logger.info("{} orphans deleted", nbDeleted);
			return null;
		}, false);
	}

	public static final class Factory implements IVerticleFactory, IUniqueVerticleFactory {
		@Override
		public boolean isWorker() {
			return true;
		}

		@Override
		public Verticle newInstance() {
			return new CleanPclOrphanVerticle();
		}
	}
}
