package net.bluemind.exchange.mapi.persistence.factory;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.annotations.VisibleForTesting;

import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.BmContext;
import net.bluemind.exchange.mapi.persistence.pclcache.MapiPCLCacheStore;
import net.bluemind.exchange.mapi.persistence.pclcache.migration.MapiPCLCachePostgresToMapDbMigrationStore;
import net.bluemind.exchange.mapi.persistence.pclcache.migration.PclCacheMigrationDoneFlag;
import net.bluemind.exchange.mapi.repository.IMapiPCLCacheStore;
import net.bluemind.repository.provider.IStandaloneFactory;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTask;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTaskStatus;
import net.bluemind.system.api.hot.upgrade.IHotUpgrade;

public class MapiPCLCacheStoreFactory implements IStandaloneFactory<IMapiPCLCacheStore> {

	private static final Logger logger = LoggerFactory.getLogger(MapiPCLCacheStoreFactory.class);

	public static final String MIGRATION_OPERATION_NAME = "pcl-cache-mapdb-to-postgres";
	private static HotUpgradeTask migrationTask = null;

	@Override
	public Class<IMapiPCLCacheStore> factoryClass() {
		return IMapiPCLCacheStore.class;
	}

	@Override
	public DataSourceType targetRepositoryType() {
		return DataSourceType.POSTGRESQL;
	}

	@Override
	public IMapiPCLCacheStore instance(BmContext context) throws ServerFault {
		if (migrationTask == null) {
			migrationTask = getHotUpgrade(context);
		}
		boolean migrationNotExist = migrationTask == null;
		boolean migrationFinished = (!migrationNotExist && migrationTask.status == HotUpgradeTaskStatus.SUCCESS
				|| PclCacheMigrationDoneFlag.get().isAllDone());

		if (migrationNotExist || migrationFinished) {
			return postgresStore(context);
		}
		logger.warn("Use hybride store (migrationNotExist: {}, migrationFinished: {})", migrationNotExist,
				migrationFinished);
		return hybridStore(context);
	}

	private static HotUpgradeTask getHotUpgrade(BmContext context) {
		IHotUpgrade hotUpgradeService = context.provider().instance(IHotUpgrade.class);
		HotUpgradeTaskFilter filter = HotUpgradeTaskFilter.filter().operation(MIGRATION_OPERATION_NAME);

		List<HotUpgradeTask> migrations = hotUpgradeService.list(filter);
		boolean notFound = migrations == null || migrations.isEmpty();
		return notFound ? null : migrations.getFirst();
	}

	@VisibleForTesting
	public static void resetForTests() {
		migrationTask = null;
	}

	private static MapiPCLCacheStore postgresStore(BmContext context) {
		return new MapiPCLCacheStore(context.getAllMailboxDataSource().getFirst());
	}

	private static MapiPCLCachePostgresToMapDbMigrationStore hybridStore(BmContext context) {
		return new MapiPCLCachePostgresToMapDbMigrationStore(context.getAllMailboxDataSource().getFirst());
	}

}
