package net.bluemind.exchange.mapi.persistence.factory;

import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.BmContext;
import net.bluemind.exchange.mapi.persistence.MapiPidMappingStore;
import net.bluemind.exchange.mapi.repository.IMapiPidMappingStore;
import net.bluemind.repository.provider.IStandaloneFactory;

public class MapiPidMappingStoreFactory implements IStandaloneFactory<IMapiPidMappingStore> {

	@Override
	public Class<IMapiPidMappingStore> factoryClass() {
		return IMapiPidMappingStore.class;
	}

	@Override
	public DataSourceType targetRepositoryType() {
		return DataSourceType.POSTGRESQL;
	}

	@Override
	public MapiPidMappingStore instance(BmContext context) throws ServerFault {
		return new MapiPidMappingStore(context.getDataSource());
	}

}
