package net.bluemind.exchange.mapi.persistence.pclcache;

import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Verticle;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.lib.vertx.IUniqueVerticleFactory;
import net.bluemind.lib.vertx.IVerticleFactory;
import net.bluemind.lib.vertx.VertxPlatform;

public class CleanPclOrphanVerticle extends AbstractVerticle {
	private static final Logger logger = LoggerFactory.getLogger(CleanPclOrphanVerticle.class);

	private final long nbMilliSecondsTimer;

	private MapiPCLCacheStore pclStore;

	public CleanPclOrphanVerticle() {
		this(TimeUnit.HOURS.toMillis(24));
	}

	public CleanPclOrphanVerticle(long nbMilliSecondsTimer) {
		this.nbMilliSecondsTimer = nbMilliSecondsTimer;
		BmContext context = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM).getContext();
		pclStore = new MapiPCLCacheStore(context.getAllMailboxDataSource().getFirst());
	}

	@Override
	public void start() throws Exception {
		vertx.setTimer(nbMilliSecondsTimer, ev -> {
			this.execute(ev);
			VertxPlatform.executeBlockingPeriodic(vertx, nbMilliSecondsTimer, this::execute);
		});
	}

	private void execute(Long timerId) {
		// for each pcl entry check container_item exists
		vertx.executeBlocking(() -> {
			logger.info("Start clean orphans");
			long nbDeleted = pclStore.cleanOrphan();
			logger.info("{} orphans deleted", nbDeleted);
			return null;
		}, false);
	}

	public static final class Factory implements IVerticleFactory, IUniqueVerticleFactory {
		@Override
		public boolean isWorker() {
			return true;
		}

		@Override
		public Verticle newInstance() {
			return new CleanPclOrphanVerticle();
		}
	}
}
