package net.bluemind.elastic.topology.service.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.common.task.Tasks;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.core.task.api.TaskRef;
import net.bluemind.core.task.service.IServerTaskMonitor;
import net.bluemind.core.task.service.ITasksManager;
import net.bluemind.elastic.topology.service.EsTopology;
import net.bluemind.elastic.topology.service.ops.UpdateReplicationFactor;
import net.bluemind.network.topology.Topology;
import net.bluemind.server.api.Server;
import net.bluemind.system.schemaupgrader.PostInst;
import net.bluemind.system.schemaupgrader.UpdateResult;

public class EnsureReplicationFactorPostinst implements PostInst {

	private static final Logger logger = LoggerFactory.getLogger(EnsureReplicationFactorPostinst.class);

	@Override
	public UpdateResult executeUpdate(IServerTaskMonitor monitor) {
		ServerSideServiceProvider prov = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM);
		ITasksManager mgr = prov.instance(ITasksManager.class);

		List<ItemValue<Server>> dataHolders = Topology.get().all(EsTopology.ES_DATA_TAG);
		if (dataHolders.size() > 1) {

			Thread.ofVirtual().name("es-reconfigure").start(() -> {
				int replicationFactors = dataHolders.size() / 2 + 1;
				int extraCopies = replicationFactors - 1;

				monitor.begin(1, "Update ES extra copies to " + extraCopies);
				UpdateReplicationFactor repl = new UpdateReplicationFactor(dataHolders.getFirst(), extraCopies);
				TaskRef taskref = mgr.run(repl);
				Tasks.followStream(prov, logger, "ElasticReplicationFactor", taskref).whenComplete((status, ex) -> {
					if (ex != null) {
						monitor.end(false, ex.getMessage(), "FAILED");
					} else {
						monitor.end(true, "Updated", "OK");
					}
				}).join();
			});

		}

		return UpdateResult.ok();
	}

}
