/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.eas.testhelper.session;

import net.bluemind.eas.dto.device.DeviceId;
import net.bluemind.eas.dto.user.MSUser;
import net.bluemind.eas.session.BackendSession;

public class BackendSessionTest extends BackendSession {

	public BackendSessionTest(MSUser user, DeviceId device, double protocolVersion) {
		super(user, device, protocolVersion);
	}

	@Override
	public String getLoginAtDomain() {
		if (super.user == null) {
			return null;
		}
		return super.getLoginAtDomain();
	}

	@Override
	public String getDevId() {
		if (super.deviceId == null) {
			return null;
		}
		return super.getDevId();
	}
}
