/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2023
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.directory.service;

import java.util.List;

import net.bluemind.core.auditlogs.AuditLogUpdateStatus;
import net.bluemind.core.auditlogs.ContentElement;
import net.bluemind.core.auditlogs.ContentElement.ContentElementBuilder;
import net.bluemind.core.auditlogs.ILogMapperProvider;

public abstract class AuditLogDirEntryMapper<T> implements ILogMapperProvider<DirEntryAndValue<T>> {
	protected static final String CRLF = "\r\n";

	public ContentElementBuilder createContentElementBuilder(DirEntryAndValue<T> dirEntryAndValue) {
		ContentElementBuilder builder = new ContentElement.ContentElementBuilder();
		builder.description(dirEntryAndValue.entry.displayName).key(dirEntryAndValue.entry.entryUid)
				.is(List.of(dirEntryAndValue.entry.kind.name())).newValue(dirEntryAndValue.value.toString());
		return builder;
	}

	@Override
	public abstract AuditLogUpdateStatus createUpdateMessage(DirEntryAndValue<T> oldValue, DirEntryAndValue<T> newValue)
			throws Exception;

}