/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.directory.repository;

import java.time.Instant;
import java.util.List;
import java.util.Set;

import net.bluemind.directory.api.DirEntry;
import net.bluemind.mailbox.api.Mailbox;
import net.bluemind.mailbox.api.Mailbox.Routing;
import net.bluemind.mailbox.api.Mailbox.Type;

public class DirEntryNG extends DirEntry {

	public long itemId;
	public String mailboxName;
	public Routing routing;
	public Set<String> memberOf;
	public Set<String> roles;
	public List<Sig> signatures;
	public LoginCaps loginCaps;

	public DirEntryNG() {
		this.dataLocation = "scylladb";
	}

	public static class Sig {
		public String name;
		public String displayName;
		public String email;
		public boolean isHtml;
		public String sentFolder;
	}

	public static class LoginCaps {
		public String passwordHash;
		public boolean mustChange;
		public boolean neverExpires;
		public Instant lastChange;
	}

	public static DirEntryNG of(DirEntry entry) {
		DirEntryNG ng = new DirEntryNG();
		ng.kind = entry.kind;
		ng.entryUid = entry.entryUid;
		ng.email = entry.email;
		ng.emails = entry.emails;
		ng.archived = entry.archived;
		ng.system = entry.system;
		ng.minId = entry.minId;
		ng.orgUnitUid = entry.orgUnitUid;
		ng.hidden = entry.hidden;
		ng.displayName = entry.displayName;

		return ng;
	}

	public Mailbox asMailbox() {
		Mailbox mb = new Mailbox();
		mb.type = fromKind(kind);
		mb.name = mailboxName;
		mb.emails = emails;
		mb.routing = routing;
		mb.archived = archived;
		mb.hidden = hidden;
		mb.system = system;
		mb.dataLocation = dataLocation;
		return mb;
	}

	private Mailbox.Type fromKind(Kind k) {
		return switch (k) {
		case GROUP:
			yield Type.group;
		case MAILSHARE:
			yield Type.mailshare;
		case RESOURCE:
			yield Type.resource;
		case USER:
			yield Type.user;
		case ADDRESSBOOK, CALENDAR, DOMAIN, EXTERNALUSER, ORG_UNIT:
			yield null;
		};
	}

}
