/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2018
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.hollow.datamodel;

import java.util.List;

import com.netflix.hollow.core.write.objectmapper.HollowInline;

public class AddressBookRecordIndexOnly {

	@HollowInline
	public String uid;
	@HollowInline
	public String distinguishedName;
	public List<Email> emails;
	public List<AnrToken> anr;
	public String kind;
	public long minimalid;

	public String getUid() {
		return uid;
	}

	public String getDistinguishedName() {
		return distinguishedName;
	}

	public List<Email> getEmails() {
		return emails;
	}

	public List<AnrToken> getAnr() {
		return anr;
	}

	public String getKind() {
		return kind;
	}

	public long getMinimalid() {
		return minimalid;
	}

}
