package net.bluemind.directory.hollow.datamodel.producer.multicore;

import java.time.Duration;
import java.util.List;
import java.util.Optional;

import net.bluemind.directory.hollow.datamodel.AddressBookRecord;
import net.bluemind.directory.hollow.datamodel.OfflineAddressBook;

public interface IMultiCoreDirectorySerializerStore {

	long getVersion();

	void finishSerialization(long newVersion);

	void batchSaveDeleteAdressBookRecord(long version, List<AddressBookRecord> createRecord, List<String> deletedUid);

	AddressBookRecord getAdressBookRecord(long version, String uid);

	void copyAdressBookRecords(long version, long newVersion);

	void setAdressBookRecordExpire(long version, Optional<Duration> ttl);

	void deleteAllAdressBookRecords(long oldVersion);

	void saveOfflineAddressBook(long nextVersion, OfflineAddressBook oab);
}
