package net.bluemind.directory.hollow.datamodel.producer.multicore.keydb;

import java.util.function.Supplier;

import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import net.bluemind.directory.hollow.datamodel.AddressBookRecord;
import net.bluemind.directory.hollow.datamodel.OfflineAddressBook;
import net.bluemind.keydb.common.ClientProvider;
import net.bluemind.keydb.common.ObjectCodec;

public class RedisConnections {
	private static RedisConnections instance = null;
	private static final Object lock = new Object();

	public static final Supplier<RedisConnections> factory = () -> {
		synchronized (lock) {
			if (instance == null) {
				instance = new RedisConnections();
			}
		}
		return instance;
	};

	private RedisCommands<String, String> versionCommand;
	private RedisCommands<String, AddressBookRecord> recordCommand;
	private RedisCommands<String, OfflineAddressBook> offlineRecordCommand;
	private RedisAsyncCommands<String, AddressBookRecord> asyncRecordCommand;

	private RedisConnections() {
		StatefulRedisConnection<String, String> connection = ClientProvider.newClient().connect();
		versionCommand = connection.sync();
		StatefulRedisConnection<String, AddressBookRecord> recordConnection = ClientProvider.newClient()
				.connect(new ObjectCodec<AddressBookRecord>(AddressBookRecord.class));
		recordCommand = recordConnection.sync();
		asyncRecordCommand = recordConnection.async();

		StatefulRedisConnection<String, OfflineAddressBook> offlineRecordConnection = ClientProvider.newClient()
				.connect(new ObjectCodec<OfflineAddressBook>(OfflineAddressBook.class));
		offlineRecordCommand = offlineRecordConnection.sync();
	}

	public RedisCommands<String, String> getVersionCommand() {
		return versionCommand;
	}

	public RedisCommands<String, AddressBookRecord> getRecordCommand() {
		return recordCommand;
	}

	public RedisCommands<String, OfflineAddressBook> getOfflineRecordCommand() {
		return offlineRecordCommand;
	}

	public RedisAsyncCommands<String, AddressBookRecord> getAsyncRecordCommand() {
		return asyncRecordCommand;
	}

}
