/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.hollow.datamodel.producer;

import java.util.concurrent.TimeUnit;

import com.typesafe.config.Config;

import net.bluemind.core.serialization.DataSerializationFactory;
import net.bluemind.directory.hollow.datamodel.producer.multicore.MultiCoreDirectorySerializer;
import net.bluemind.directory.hollow.datamodel.producer.multicore.keydb.KeyDbMultiCoreDirectorySerializerStore;

public class DirectorySerializerFactory implements DataSerializationFactory {

	@Override
	public IDirectorySerializer create(String subset) {
		Config conf = HollowConfig.get();
		long throttleMs = (long) conf.getDuration("hollow.dir.throttle", TimeUnit.MILLISECONDS);
		return new MultiCoreDirectorySerializer(subset, new KeyDbMultiCoreDirectorySerializerStore(subset), throttleMs);
	}

	@Override
	public String supportedSet() {
		return "directory";
	}

}
