package net.bluemind.directory.hollow.datamodel.consumer.multicore;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

import net.bluemind.directory.hollow.datamodel.AddressBookRecord;
import net.bluemind.directory.hollow.datamodel.AddressBookRecordIndexOnly;
import net.bluemind.directory.hollow.datamodel.OfflineAddressBook;

public interface IMultiCoreDirectoryDeserializerStore {

	List<AddressBookRecord> getAllAdressBookRecords(long version, Predicate<AddressBookRecord> filter);

	void forEachIndex(long version, Consumer<AddressBookRecordIndexOnly> consumer);

	OfflineAddressBook getOfflineAdressBookRecords(long version);

	AddressBookRecord getAdressBookRecord(long version, String uid);

	List<AddressBookRecord> batchGetAdressBookRecords(long version, Collection<String> uids);

	long getVersion();

	void watchVersionUpdate(Runnable onUpdate);

	void stopWatchVersionUpdate();

	boolean isWatchingVersionUpdate();

}
