package net.bluemind.directory.hollow.datamodel.consumer.multicore.index;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import net.bluemind.directory.hollow.datamodel.AddressBookRecordIndexOnly;

public abstract class DeserializerIndexMultiMap implements IDeserializerIndexMulti {

	protected Map<String, Collection<String>> index = new HashMap<>();

	@Override
	public void add(AddressBookRecordIndexOnly addressBook, String uid) {
		getIndexKeys(addressBook).stream()
				.forEach(indexKey -> index.computeIfAbsent(indexKey, k -> new HashSet<>()).add(uid));

	}

	@Override
	public Collection<String> getUids(String key) {
		return index.containsKey(key) ? index.get(key) : new HashSet<>();
	}

	public abstract List<String> getIndexKeys(AddressBookRecordIndexOnly addressBookRecord);
}
