package net.bluemind.directory.hollow.datamodel.consumer;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;

import net.bluemind.directory.hollow.datamodel.AddressBookRecord;
import net.bluemind.directory.hollow.datamodel.OfflineAddressBook;

public interface IDirectoryDeserializer {

	void stopWatcher();

	boolean isWatcherListening();

	Optional<OfflineAddressBook> root();

	Optional<AddressBookRecord> byDistinguishedName(String distinguishedName);

	Optional<AddressBookRecord> byUid(String uid);

	Optional<AddressBookRecord> byMinimalId(long minimalId);

	Optional<AddressBookRecord> byEmail(String email);

	Collection<AddressBookRecord> all();

	void forEach(Consumer<AddressBookRecord> cons);

	Collection<AddressBookRecord> search(Query query);

	Collection<AddressBookRecord> byNameOrEmailPrefix(String value);

	SearchResults byKind(List<String> kinds, int offset, int limit, Predicate<AddressBookRecord> filter);

}
