package net.bluemind.directory.hollow.datamodel.consumer.multicore.index.impl;

import java.util.Optional;

import net.bluemind.directory.hollow.datamodel.AddressBookRecordIndexOnly;
import net.bluemind.directory.hollow.datamodel.consumer.multicore.index.DeserializerIndexMonoMap;

public class ByDistinguishedName extends DeserializerIndexMonoMap {

	@Override
	public String getIndexKey(AddressBookRecordIndexOnly addressBookRecord) {
		return addressBookRecord.getDistinguishedName().toLowerCase();
	}

	@Override
	public Optional<String> simpleQueryFieldName() {
		return Optional.of("distinguishedName");
	}
}
