package net.bluemind.directory.hollow.datamodel.consumer.multicore.index.trie;

import java.util.Arrays;
import java.util.Set;

public class Trie {
	private TrieNode root = new TrieNode(Character.MIN_VALUE);

	public Set<String> get(String key) {
		TrieNode current = root;
		if (key != null) {
			for (char character : key.toCharArray()) {
				TrieNode nextCurrent = null;
				if (current.getChildren() != null) {
					for (TrieNode child : current.getChildren()) {
						if (child.getLetter() == character) {
							nextCurrent = child;
							break;
						}
					}
				}
				if (nextCurrent != null) {
					current = nextCurrent;
				} else {
					return Set.of();
				}
			}
		}

		if (current.getContent() != null) {
			return Set.of(current.getContent());
		} else {
			return Set.of();
		}
	}

	public void put(String key, String value) {
		TrieNode current = root;
		for (char character : key.toCharArray()) {
			TrieNode maybeNewNode = new TrieNode(character);
			TrieNode nextCurrent = null;
			TrieNode[] children = current.getChildren();
			if (children != null) {
				int foundIndex = Arrays.binarySearch(children, maybeNewNode);
				if (foundIndex >= 0) {
					nextCurrent = children[foundIndex];
				}
			}

			if (nextCurrent == null) {
				if (children != null) {
					children = Arrays.copyOf(children, children.length + 1);
					children[children.length - 1] = maybeNewNode;
					Arrays.sort(children);
				} else {
					children = new TrieNode[1];
					children[0] = maybeNewNode;
				}
				current.setChildren(children);
				nextCurrent = maybeNewNode;
			}
			current = nextCurrent;
		}

		String[] content = current.getContent();
		if (content == null) {
			String[] newContent = new String[1];
			newContent[0] = value;
			current.setContent(newContent);
		} else {
			for (int i = 0; i < content.length; i++) {
				if (content[i] == value) {
					return;
				}
			}
			String[] newContent = Arrays.copyOf(content, content.length + 1);
			newContent[newContent.length - 1] = value;
			current.setContent(newContent);
		}
	}

}
