package net.bluemind.directory.hollow.datamodel.consumer.multicore;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

import net.bluemind.directory.hollow.datamodel.AddressBookRecord;

public class AddressBookRecordFieldAccessor extends ObjectFieldAccessor<AddressBookRecord> {

	private static Map<String, Function<AddressBookRecord, Object>> fieldGetters = new HashMap<>();

	static {
		fieldGetters.put("uid", o -> o.getUid());
		fieldGetters.put("distinguishedName", o -> o.getDistinguishedName());
		fieldGetters.put("domain", o -> o.getDomain());
		fieldGetters.put("kind", o -> o.getKind());
		fieldGetters.put("emails", o -> o.getEmails());
		fieldGetters.put("created", o -> o.getCreated());
		fieldGetters.put("updated", o -> o.getUpdated());
		fieldGetters.put("email", o -> o.getEmail());
		fieldGetters.put("minimalid", o -> o.getMinimalid());
		fieldGetters.put("name", o -> o.getName());
		fieldGetters.put("surname", o -> o.getSurname());
		fieldGetters.put("givenName", o -> o.getGivenName());
		fieldGetters.put("title", o -> o.getTitle());
		fieldGetters.put("officeLocation", o -> o.getOfficeLocation());
		fieldGetters.put("departmentName", o -> o.getDepartmentName());
		fieldGetters.put("companyName", o -> o.getCompanyName());
		fieldGetters.put("assistant", o -> o.getAssistant());
		fieldGetters.put("addressBookManagerDistinguishedName", o -> o.getAddressBookManagerDistinguishedName());
		fieldGetters.put("addressBookPhoneticGivenName", o -> o.getAddressBookPhoneticGivenName());
		fieldGetters.put("addressBookPhoneticSurname", o -> o.getAddressBookPhoneticSurname());
		fieldGetters.put("addressBookPhoneticCompanyName", o -> o.getAddressBookPhoneticCompanyName());
		fieldGetters.put("addressBookPhoneticDepartmentName", o -> o.getAddressBookPhoneticDepartmentName());
		fieldGetters.put("streetAddress", o -> o.getStreetAddress());
		fieldGetters.put("postOfficeBox", o -> o.getPostOfficeBox());
		fieldGetters.put("locality", o -> o.getLocality());
		fieldGetters.put("stateOrProvince", o -> o.getStateOrProvince());
		fieldGetters.put("postalCode", o -> o.getPostalCode());
		fieldGetters.put("country", o -> o.getCountry());
		fieldGetters.put("dataLocation", o -> o.getDataLocation());
		fieldGetters.put("businessTelephoneNumber", o -> o.getBusinessTelephoneNumber());
		fieldGetters.put("homeTelephoneNumber", o -> o.getHomeTelephoneNumber());
		fieldGetters.put("business2TelephoneNumbers", o -> o.getBusiness2TelephoneNumbers());
		fieldGetters.put("home2TelephoneNumber", o -> o.getHome2TelephoneNumber());
		fieldGetters.put("mobileTelephoneNumber", o -> o.getMobileTelephoneNumber());
		fieldGetters.put("pagerTelephoneNumber", o -> o.getPagerTelephoneNumber());
		fieldGetters.put("primaryFaxNumber", o -> o.getPrimaryFaxNumber());
		fieldGetters.put("assistantTelephoneNumber", o -> o.getAssistantTelephoneNumber());
		fieldGetters.put("userCertificate", o -> o.getUserCertificate());
		fieldGetters.put("addressBookX509Certificate", o -> o.getAddressBookX509Certificate());
		fieldGetters.put("userX509Certificate", o -> o.getUserX509Certificate());
		fieldGetters.put("thumbnail", o -> o.getThumbnail());
		fieldGetters.put("hidden", o -> o.getHidden());
		fieldGetters.put("anr", o -> o.getAnr());
	}

	public AddressBookRecordFieldAccessor() {
		super(AddressBookRecord.class, fieldGetters);
	}

}
