package net.bluemind.directory.hollow.datamodel.consumer.multicore;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class ObjectFieldAccessor<T> {

	private Map<String, Function<T, Object>> fieldGetters = new HashMap<>();
	private Class<T> typeParameterClass;

	public ObjectFieldAccessor(Class<T> typeParameterClass, Map<String, Function<T, Object>> fieldGetters) {
		this.fieldGetters = fieldGetters;
		this.typeParameterClass = typeParameterClass;
		for (Field field : Arrays.asList(this.typeParameterClass.getDeclaredFields())) {
			if (!fieldGetters.containsKey(field.getName())) {
				throw new IllegalArgumentException(field.getName() + " getter is missing");
			}
		}
	}

	public String getAsString(T instance, String fieldName) {
		Object result = fieldGetters.get(fieldName).apply(instance);
		return result != null ? result.toString() : null;
	}
}
