<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2017
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
namespace BM;
require_once 'GlobalEnv.php';

/**
 * Implementation of net.bluemind.directory.api.IOrgUnits.
 */

class OrgUnitsClient {

  protected $base;
  protected $sid;
  protected $domain;

  /*
   * Constructor.
   *
   * @param base
   * @param sid
   * @param domain
   *
   */
  public function __construct($base, $sid , $domain) {
    $this->sid = $sid;
    $this->base = $base."/api/directory/_ou/{domain}";
    $this->domain = $domain;
    $this->base = str_replace("{domain}", urlencode($domain), $this->base);
  }


  /*
   * @param uid
   * @param value
   * @return
   */
  public function create( $uid ,  $value  ) {
    $postUri = "/{uid}";
    $method = "PUT";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $value;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function delete_( $uid  ) {
    $postUri = "/{uid}";
    $method = "DELETE";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param dirUid
   * @param groups
   * @return
   */
  public function getAdministratorRoles( $uid ,  $dirUid ,  $groups  ) {
    $postUri = "/{uid}/{dirUid}";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);
    $postUri = str_replace("{dirUid}", urlencode($dirUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $groups;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param hierarchical
   * @return
   */
  public function getAdministrators( $uid ,  $hierarchical  ) {
    $postUri = "/{uid}/_administrators";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array(
      "hierarchical" => $hierarchical);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getChildren( $uid  ) {
    $postUri = "/{uid}/_children";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getComplete( $uid  ) {
    $postUri = "/{uid}/complete";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getPath( $uid  ) {
    $postUri = "/{uid}/path";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param administrator
   * @param groups
   * @return
   */
  public function listByAdministrator( $administrator ,  $groups  ) {
    $postUri = "/_byAdmin";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array(
      "administrator" => $administrator);

    $body = null;
    $body = $groups;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param administrator
   * @return
   */
  public function removeAdministrator( $administrator  ) {
    $postUri = "/_deleteadmin";
    $method = "DELETE";


    $url = $this->base.$postUri;

    $queryParam = array(
      "administrator" => $administrator);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param query
   * @return
   */
  public function search( $query  ) {
    $postUri = "/_search";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $query;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param dirUid
   * @param roles
   * @return
   */
  public function setAdministratorRoles( $uid ,  $dirUid ,  $roles  ) {
    $postUri = "/{uid}/{dirUid}/_set";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);
    $postUri = str_replace("{dirUid}", urlencode($dirUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $roles;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param value
   * @return
   */
  public function update( $uid ,  $value  ) {
    $postUri = "/{uid}";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $value;
    return $this->execute($url, $queryParam, $body, $method);
  }


  /*
   * Execute the request
   *
   * @param url
   * @param data
   * @param body
   */
  private function execute($url, $queryParam, $body, $method) {

    $curl = curl_init();

    $headers = array();
    array_push($headers, 'X-BM-ApiKey: '.$this->sid);

    if (sizeof($queryParam) > 0) {
      $url .= '?'.http_build_query($queryParam);
    }

    curl_setopt_array($curl, GlobalEnv::$curlOptions + array(
      CURLOPT_URL => $url,
      CURLOPT_HTTPHEADER => $headers,
      CURLOPT_CUSTOMREQUEST => $method)
    );

    if ($method == 'POST') {
      curl_setopt($curl, CURLOPT_POST, TRUE);
      curl_setopt($curl, CURLOPT_POSTFIELDS, array());
    }

    if (is_resource($body)) {
      if ($method == 'PUT') {
        curl_setopt($curl, CURLOPT_PUT, TRUE);
      }
      $size = fstat($body)['size'];
      curl_setopt($curl, CURLOPT_INFILE, $body);
      curl_setopt($curl, CURLOPT_INFILESIZE, $size);
    } else {
      if (is_object($body) && method_exists($body, 'serialize')) {
        $body = $body->serialize();
      } else if (is_object($body)) {
        $body = json_encode($body);
      } else if (is_array($body)) {
        $body = json_encode($body);
      } else if (is_string($body)) {
        $body = json_encode($body);
      }
      $size = strlen($body);
      array_push($headers, 'Content-Type: application/json');
      array_push($headers, 'Content-Length: '.$size);
      curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($curl, CURLOPT_POSTFIELDS, $body);
    }

    $resp = curl_exec($curl);
    if ($resp === false) {
      throw new \Exception(curl_error($curl));
    } 
    curl_close($curl);
    if (!$resp) {
      return;
    }
    $js = json_decode($resp);
    if ($js === NULL) {
      return $resp;
    }
    if (isset($js->errorCode)) {
      throw new \Exception($js->errorCode . ': ' . (isset($js->message) ? ' : ' . $js->message : ''));
    }
    return $js;
  }

}
