<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * BaseDirEntry.
 */
class BaseDirEntry  {

  /*
   * @type String
   */
  public $displayName;

  /*
   * @type String
   */
  public $entryUid;

  /*
   * @type BaseDirEntryAccountType
   */
  public $accountType;

  /*
   * @type BaseDirEntryKind
   */
  public $kind;

  /*
   * Constructor
   */
  public function __construct() {
    $this->displayName = "";
    $this->entryUid = "";
  }

  public function toMap() {
    $data = array(    
        "displayName" => empty($this->displayName) ? null : $this->displayName,    
        "entryUid" => empty($this->entryUid) ? null : $this->entryUid,    
        "accountType" => empty($this->accountType) ? null : $this->accountType,    
        "kind" => empty($this->kind) ? null : $this->kind);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
