/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.directory.api.IOrgUnits.
 */

goog.provide('net.bluemind.directory.api.OrgUnitsClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.directory.api.IOrgUnits API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} domain
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.directory.api.OrgUnitsClient = function(rpc, base , domain ) {
  goog.base(this, rpc, base);
  this.base += '/directory/_ou/{domain}';
   this.domain_ = domain;
   this.base = this.base.replace('{domain}',goog.string.urlEncode(domain));
};

goog.inherits(net.bluemind.directory.api.OrgUnitsClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} domain
 * @private
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.domain_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} value
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.create = function( uid ,  value  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "create_" 
                                  + this.domain_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = value;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "delete_" 
                                  + this.domain_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {string} dirUid
 * @param {Array.<string>} groups
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.getAdministratorRoles = function( uid ,  dirUid ,  groups  ) {

  var postUri = "/{uid}/{dirUid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  postUri = postUri.replace("{dirUid}", goog.string.urlEncode(dirUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getAdministratorRoles_" 
                                  + this.domain_
                                  + uid
                                  + dirUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = groups;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {boolean} hierarchical
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.getAdministrators = function( uid ,  hierarchical  ) {

  var postUri = "/{uid}/_administrators";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(hierarchical)) {
    url.getQueryData().add('hierarchical', hierarchical);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "getAdministrators_" 
                                  + this.domain_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.getChildren = function( uid  ) {

  var postUri = "/{uid}/_children";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getChildren_" 
                                  + this.domain_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.getComplete = function( uid  ) {

  var postUri = "/{uid}/complete";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getComplete_" 
                                  + this.domain_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.getPath = function( uid  ) {

  var postUri = "/{uid}/path";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getPath_" 
                                  + this.domain_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} administrator
 * @param {Array.<string>} groups
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.listByAdministrator = function( administrator ,  groups  ) {

  var postUri = "/_byAdmin";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(administrator)) {
    url.getQueryData().add('administrator', administrator);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "listByAdministrator_" 
                                  + this.domain_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = groups;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} administrator
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.removeAdministrator = function( administrator  ) {

  var postUri = "/_deleteadmin";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(administrator)) {
    url.getQueryData().add('administrator', administrator);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "removeAdministrator_" 
                                  + this.domain_
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.search = function( query  ) {

  var postUri = "/_search";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "search_" 
                                  + this.domain_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = query;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {string} dirUid
 * @param {Array.<string>} roles
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.setAdministratorRoles = function( uid ,  dirUid ,  roles  ) {

  var postUri = "/{uid}/{dirUid}/_set";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  postUri = postUri.replace("{dirUid}", goog.string.urlEncode(dirUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setAdministratorRoles_" 
                                  + this.domain_
                                  + uid
                                  + dirUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = roles;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} value
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsClient.prototype.update = function( uid ,  value  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "update_" 
                                  + this.domain_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = value;
  return this.execute(cmd, body);
};

