/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.directory.api.IOrgUnits.
 */

goog.provide('net.bluemind.directory.api.OrgUnitsVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.directory.api.IOrgUnits API.
 * @param {string sessionId} sessionId
*  @param {string} domain
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.directory.api.OrgUnitsVertxClient = function( sessionId , domain ) {
  this.sessionId = sessionId;
  this.base = '/directory/_ou/{domain}';
  this.domain_ = domain;
  this.base = this.base.replace('{domain}',goog.string.urlEncode(domain));
};

goog.inherits(net.bluemind.directory.api.OrgUnitsVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} domain
 * @private
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.domain_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} value
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.create = function( uid ,  value  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = value;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {string} dirUid
 * @param {Array.<string>} groups
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.getAdministratorRoles = function( uid ,  dirUid ,  groups  ) {

  var postUri = "/{uid}/{dirUid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  postUri = postUri.replace("{dirUid}", goog.string.urlEncode(dirUid));
  var params = {};



  var body = null;
  body = groups;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {boolean} hierarchical
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.getAdministrators = function( uid ,  hierarchical  ) {

  var postUri = "/{uid}/_administrators";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};

  if (goog.isDefAndNotNull(hierarchical)) {
    params['hierarchical'] = hierarchical;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.getChildren = function( uid  ) {

  var postUri = "/{uid}/_children";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.getComplete = function( uid  ) {

  var postUri = "/{uid}/complete";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.getPath = function( uid  ) {

  var postUri = "/{uid}/path";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} administrator
 * @param {Array.<string>} groups
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.listByAdministrator = function( administrator ,  groups  ) {

  var postUri = "/_byAdmin";

  var params = {};

  if (goog.isDefAndNotNull(administrator)) {
    params['administrator'] = administrator;
  }


  var body = null;
  body = groups;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} administrator
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.removeAdministrator = function( administrator  ) {

  var postUri = "/_deleteadmin";

  var params = {};

  if (goog.isDefAndNotNull(administrator)) {
    params['administrator'] = administrator;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.search = function( query  ) {

  var postUri = "/_search";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {string} dirUid
 * @param {Array.<string>} roles
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.setAdministratorRoles = function( uid ,  dirUid ,  roles  ) {

  var postUri = "/{uid}/{dirUid}/_set";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  postUri = postUri.replace("{dirUid}", goog.string.urlEncode(dirUid));
  var params = {};



  var body = null;
  body = roles;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} value
 * @return {Object}
 */
net.bluemind.directory.api.OrgUnitsVertxClient.prototype.update = function( uid ,  value  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = value;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

