/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.directory.api.IDirectory.
 */

goog.provide('net.bluemind.directory.api.DirectoryClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.directory.api.IDirectory API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} domain
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.directory.api.DirectoryClient = function(rpc, base , domain ) {
  goog.base(this, rpc, base);
  this.base += '/directory/{domain}';
   this.domain_ = domain;
   this.base = this.base.replace('{domain}',goog.string.urlEncode(domain));
};

goog.inherits(net.bluemind.directory.api.DirectoryClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} domain
 * @private
 */
net.bluemind.directory.api.DirectoryClient.prototype.domain_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.changeset = function( since  ) {

  var postUri = "/_changeset";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(since)) {
    url.getQueryData().add('since', since);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "changeset_" 
                                  + this.domain_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.delete_ = function( path  ) {

  var postUri = "/{path}";

  postUri = postUri.replace("{path}", goog.string.urlEncode(path));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "delete_" 
                                  + this.domain_
                                  + path
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} entryUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.deleteByEntryUid = function( entryUid  ) {

  var postUri = "/_byentryuid/{entryUid}";

  postUri = postUri.replace("{entryUid}", goog.string.urlEncode(entryUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "deleteByEntryUid_" 
                                  + this.domain_
                                  + entryUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} entryUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.findByEntryUid = function( entryUid  ) {

  var postUri = "/entry-uid/{entryUid}";

  postUri = postUri.replace("{entryUid}", goog.string.urlEncode(entryUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "findByEntryUid_" 
                                  + this.domain_
                                  + entryUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} entryUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.findItemValueByEntryUid = function( entryUid  ) {

  var postUri = "/item-value-uid/{entryUid}";

  postUri = postUri.replace("{entryUid}", goog.string.urlEncode(entryUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "findItemValueByEntryUid_" 
                                  + this.domain_
                                  + entryUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getByEmail = function( email  ) {

  var postUri = "/_byEmail/{email}";

  postUri = postUri.replace("{email}", goog.string.urlEncode(email));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getByEmail_" 
                                  + this.domain_
                                  + email
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} roles
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getByRoles = function( roles  ) {

  var postUri = "/_byroles";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getByRoles_" 
                                  + this.domain_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = roles;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getEntries = function( path  ) {

  var postUri = "/_childs";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getEntries_" 
                                  + this.domain_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = path;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getEntry = function( path  ) {

  var postUri = "/_entry";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getEntry_" 
                                  + this.domain_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = path;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} entryUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getEntryIcon = function( entryUid  ) {

  var postUri = "/entry-uid/{entryUid}/icon";

  postUri = postUri.replace("{entryUid}", goog.string.urlEncode(entryUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getEntryIcon_" 
                                  + this.domain_
                                  + entryUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} entryUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getEntryPhoto = function( entryUid  ) {

  var postUri = "/entry-uid/{entryUid}/photo";

  postUri = postUri.replace("{entryUid}", goog.string.urlEncode(entryUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getEntryPhoto_" 
                                  + this.domain_
                                  + entryUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getIcon = function( path  ) {

  var postUri = "/_icon/{path}";

  postUri = postUri.replace("{path}", goog.string.urlEncode(path));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getIcon_" 
                                  + this.domain_
                                  + path
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} id
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getMultiple = function( id  ) {

  var postUri = "/_mget";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMultiple_" 
                                  + this.domain_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = id;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} id
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getMultipleLight = function( id  ) {

  var postUri = "/_mgetlight";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMultipleLight_" 
                                  + this.domain_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = id;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} entryUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getRolesForDirEntry = function( entryUid  ) {

  var postUri = "/entry-uid/{entryUid}/rolesfor_";

  postUri = postUri.replace("{entryUid}", goog.string.urlEncode(entryUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getRolesForDirEntry_" 
                                  + this.domain_
                                  + entryUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} ouUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getRolesForOrgUnit = function( ouUid  ) {

  var postUri = "/ou-uid/{ouUid}/rolesfor_";

  postUri = postUri.replace("{ouUid}", goog.string.urlEncode(ouUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getRolesForOrgUnit_" 
                                  + this.domain_
                                  + ouUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getRoot = function() {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getRoot_" 
                                  + this.domain_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.getVCard = function( uid  ) {

  var postUri = "/{uid}/_vcard";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getVCard_" 
                                  + this.domain_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.search = function( query  ) {

  var postUri = "/_search";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "search_" 
                                  + this.domain_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = query;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryClient.prototype.searchUids = function( query  ) {

  var postUri = "/_searchUids";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "searchUids_" 
                                  + this.domain_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = query;
  return this.execute(cmd, body);
};

