/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.directory.api.IDirEntryMaintenance.
 */

goog.provide('net.bluemind.directory.api.DirEntryMaintenanceVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.directory.api.IDirEntryMaintenance API.
 * @param {string sessionId} sessionId
*  @param {string} domain
*  @param {string} entryUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.directory.api.DirEntryMaintenanceVertxClient = function( sessionId , domain , entryUid ) {
  this.sessionId = sessionId;
  this.base = '/directory/{domain}/{entryUid}/mgmt';
  this.domain_ = domain;
  this.base = this.base.replace('{domain}',goog.string.urlEncode(domain));
  this.entryUid_ = entryUid;
  this.base = this.base.replace('{entryUid}',goog.string.urlEncode(entryUid));
};

goog.inherits(net.bluemind.directory.api.DirEntryMaintenanceVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} domain
 * @private
 */
net.bluemind.directory.api.DirEntryMaintenanceVertxClient.prototype.domain_;
/**
 * @type {string} entryUid
 * @private
 */
net.bluemind.directory.api.DirEntryMaintenanceVertxClient.prototype.entryUid_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.directory.api.DirEntryMaintenanceVertxClient.prototype.getAvailableOperations = function() {

  var postUri = "/_maintenance";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} config
 * @return {Object}
 */
net.bluemind.directory.api.DirEntryMaintenanceVertxClient.prototype.repair = function( config  ) {

  var postUri = "/_maintenance/repair";

  var params = {};



  var body = null;
  body = config;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

