/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.directory.api.IDirectory.
 */

goog.provide('net.bluemind.directory.api.DirectoryVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.directory.api.IDirectory API.
 * @param {string sessionId} sessionId
*  @param {string} domain
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.directory.api.DirectoryVertxClient = function( sessionId , domain ) {
  this.sessionId = sessionId;
  this.base = '/directory/{domain}';
  this.domain_ = domain;
  this.base = this.base.replace('{domain}',goog.string.urlEncode(domain));
};

goog.inherits(net.bluemind.directory.api.DirectoryVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} domain
 * @private
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.domain_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.changeset = function( since  ) {

  var postUri = "/_changeset";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.delete_ = function( path  ) {

  var postUri = "/{path}";

  postUri = postUri.replace("{path}", goog.string.urlEncode(path));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} entryUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.deleteByEntryUid = function( entryUid  ) {

  var postUri = "/_byentryuid/{entryUid}";

  postUri = postUri.replace("{entryUid}", goog.string.urlEncode(entryUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} entryUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.findByEntryUid = function( entryUid  ) {

  var postUri = "/entry-uid/{entryUid}";

  postUri = postUri.replace("{entryUid}", goog.string.urlEncode(entryUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} entryUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.findItemValueByEntryUid = function( entryUid  ) {

  var postUri = "/item-value-uid/{entryUid}";

  postUri = postUri.replace("{entryUid}", goog.string.urlEncode(entryUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getByEmail = function( email  ) {

  var postUri = "/_byEmail/{email}";

  postUri = postUri.replace("{email}", goog.string.urlEncode(email));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} roles
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getByRoles = function( roles  ) {

  var postUri = "/_byroles";

  var params = {};



  var body = null;
  body = roles;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getEntries = function( path  ) {

  var postUri = "/_childs";

  var params = {};



  var body = null;
  body = path;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getEntry = function( path  ) {

  var postUri = "/_entry";

  var params = {};



  var body = null;
  body = path;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} entryUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getEntryIcon = function( entryUid  ) {

  var postUri = "/entry-uid/{entryUid}/icon";

  postUri = postUri.replace("{entryUid}", goog.string.urlEncode(entryUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} entryUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getEntryPhoto = function( entryUid  ) {

  var postUri = "/entry-uid/{entryUid}/photo";

  postUri = postUri.replace("{entryUid}", goog.string.urlEncode(entryUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} path
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getIcon = function( path  ) {

  var postUri = "/_icon/{path}";

  postUri = postUri.replace("{path}", goog.string.urlEncode(path));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} id
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getMultiple = function( id  ) {

  var postUri = "/_mget";

  var params = {};



  var body = null;
  body = id;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} id
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getMultipleLight = function( id  ) {

  var postUri = "/_mgetlight";

  var params = {};



  var body = null;
  body = id;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} entryUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getRolesForDirEntry = function( entryUid  ) {

  var postUri = "/entry-uid/{entryUid}/rolesfor_";

  postUri = postUri.replace("{entryUid}", goog.string.urlEncode(entryUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} ouUid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getRolesForOrgUnit = function( ouUid  ) {

  var postUri = "/ou-uid/{ouUid}/rolesfor_";

  postUri = postUri.replace("{ouUid}", goog.string.urlEncode(ouUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getRoot = function() {

  var postUri = "";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.getVCard = function( uid  ) {

  var postUri = "/{uid}/_vcard";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.search = function( query  ) {

  var postUri = "/_search";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.directory.api.DirectoryVertxClient.prototype.searchUids = function( query  ) {

  var postUri = "/_searchUids";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

