/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.directory.api.IDirEntryMaintenance.
 */

goog.provide('net.bluemind.directory.api.DirEntryMaintenanceClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.directory.api.IDirEntryMaintenance API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} domain
*  @param {string} entryUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.directory.api.DirEntryMaintenanceClient = function(rpc, base , domain , entryUid ) {
  goog.base(this, rpc, base);
  this.base += '/directory/{domain}/{entryUid}/mgmt';
   this.domain_ = domain;
   this.base = this.base.replace('{domain}',goog.string.urlEncode(domain));
   this.entryUid_ = entryUid;
   this.base = this.base.replace('{entryUid}',goog.string.urlEncode(entryUid));
};

goog.inherits(net.bluemind.directory.api.DirEntryMaintenanceClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} domain
 * @private
 */
net.bluemind.directory.api.DirEntryMaintenanceClient.prototype.domain_;
/**
 * @type {string} entryUid
 * @private
 */
net.bluemind.directory.api.DirEntryMaintenanceClient.prototype.entryUid_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.directory.api.DirEntryMaintenanceClient.prototype.getAvailableOperations = function() {

  var postUri = "/_maintenance";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getAvailableOperations_" 
                                  + this.domain_
                                  + this.entryUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} config
 * @return {Object}
 */
net.bluemind.directory.api.DirEntryMaintenanceClient.prototype.repair = function( config  ) {

  var postUri = "/_maintenance/repair";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "repair_" 
                                  + this.domain_
                                  + this.entryUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = config;
  return this.execute(cmd, body);
};

