/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.delivery.conversationreference.repository;

import java.sql.SQLException;
import java.util.List;

public interface IConversationReferenceStore {

	long get(Long mailboxId, List<Long> references) throws SQLException;

	default void create(ConversationReference conversationReference) throws SQLException {
		create(List.of(conversationReference));
	}

	void create(List<ConversationReference> conversationReferences) throws SQLException;

	default long deleteEntriesOlderThanOneYear() throws SQLException {
		return 0L;
	}
}
