/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.deferredaction.api.IDeferredActionContainerUids.
 */

goog.provide('net.bluemind.deferredaction.api.DeferredActionContainerUidsClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.deferredaction.api.IDeferredActionContainerUids API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.deferredaction.api.DeferredActionContainerUidsClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/deferredaction/uids';
};

goog.inherits(net.bluemind.deferredaction.api.DeferredActionContainerUidsClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionContainerUidsClient.prototype.getContainerType = function() {

  var postUri = "/_type";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getContainerType_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionContainerUidsClient.prototype.getUidForUser = function( uid  ) {

  var postUri = "/{uid}/_deferredaction";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getUidForUser_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionContainerUidsClient.prototype.getUidFordomain = function( uid  ) {

  var postUri = "/{uid}/_domain_deferredaction";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getUidFordomain_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

