/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.deferredaction.api.IDeferredAction.
 */

goog.provide('net.bluemind.deferredaction.api.DeferredActionVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.deferredaction.api.IDeferredAction API.
 * @param {string sessionId} sessionId
*  @param {string} containerUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient = function( sessionId , containerUid ) {
  this.sessionId = sessionId;
  this.base = '/deferredaction/{containerUid}';
  this.containerUid_ = containerUid;
  this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.deferredaction.api.DeferredActionVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.changeset = function( since  ) {

  var postUri = "/_changeset";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.changesetById = function( since  ) {

  var postUri = "/_changesetById";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} deferredAction
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.create = function( uid ,  deferredAction  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = deferredAction;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.deleteAll = function() {

  var postUri = "/_deleteAll";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @param {Object} arg1
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.filteredChangesetById = function( since ,  arg1  ) {

  var postUri = "/_filteredChangesetById";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  body = arg1;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.get = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} actionId
 * @param {number} to
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.getByActionId = function( actionId ,  to  ) {

  var postUri = "/{actionId}/_byaction";

  postUri = postUri.replace("{actionId}", goog.string.urlEncode(actionId));
  var params = {};

  if (goog.isDefAndNotNull(to)) {
    params['to'] = to;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} reference
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.getByReference = function( reference  ) {

  var postUri = "/{reference}/_byreference";

  postUri = postUri.replace("{reference}", goog.string.urlEncode(reference));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.getComplete = function( uid  ) {

  var postUri = "/{uid}/complete";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.getVersion = function() {

  var postUri = "/_version";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.multipleGet = function( uids  ) {

  var postUri = "/_mget";

  var params = {};



  var body = null;
  body = uids;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} deferredAction
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionVertxClient.prototype.update = function( uid ,  deferredAction  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = deferredAction;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

