/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.deferredaction.api.IDeferredActionContainerUids.
 */

goog.provide('net.bluemind.deferredaction.api.DeferredActionContainerUidsVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.deferredaction.api.IDeferredActionContainerUids API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.deferredaction.api.DeferredActionContainerUidsVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/deferredaction/uids';
};

goog.inherits(net.bluemind.deferredaction.api.DeferredActionContainerUidsVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionContainerUidsVertxClient.prototype.getContainerType = function() {

  var postUri = "/_type";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionContainerUidsVertxClient.prototype.getUidForUser = function( uid  ) {

  var postUri = "/{uid}/_deferredaction";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.deferredaction.api.DeferredActionContainerUidsVertxClient.prototype.getUidFordomain = function( uid  ) {

  var postUri = "/{uid}/_domain_deferredaction";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

