/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2022
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.webappdata.pg;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.dataprotect.api.DPError;
import net.bluemind.dataprotect.api.DPError.DPKind;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.common.restore.IMonitoredRestoreRestorableItem;
import net.bluemind.dataprotect.service.BackupDataProvider;
import net.bluemind.webappdata.api.IWebAppData;
import net.bluemind.webappdata.api.IWebAppDataUids;

public class RestoreWebAppDataTaskPg {
	private static final Logger logger = LoggerFactory.getLogger(RestoreWebAppDataTaskPg.class);

	private final DataProtectGeneration backup;
	private final IMonitoredRestoreRestorableItem restorableItem;

	/**
	 * @deprecated REMOVE THIS IN BlueMind 6+
	 */
	@Deprecated
	public RestoreWebAppDataTaskPg(DataProtectGeneration backup, IMonitoredRestoreRestorableItem item) {
		this.backup = backup;
		this.restorableItem = item;
	}

	public void run() throws Exception {
		try (BackupDataProvider bdp = new BackupDataProvider(null, SecurityContext.SYSTEM,
				restorableItem.getMonitor())) {
			BmContext back = bdp.createContextWithData(backup, restorableItem.item());
			BmContext live = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM).getContext();

			IWebAppData backupApi = back.provider().instance(IWebAppData.class,
					IWebAppDataUids.containerUid(restorableItem.entryUid()));
			IWebAppData liveApi = live.provider().instance(IWebAppData.class,
					IWebAppDataUids.containerUid(restorableItem.liveEntryUid()));

			liveApi.deleteAll();
			List<String> allUids = backupApi.allUids();

			restorableItem.monitorLog("Restoring '{}' webappdatas(s) from uid={}", allUids.size(),
					restorableItem.entryUid());
			logger.info("Backup contains {} webappdata for user {}", allUids.size(), restorableItem.displayName());

			backupApi.multipleGet(allUids).forEach(item -> {
				liveApi.create(item.uid, item.value);
				restorableItem.monitorLog("Restoring webappdata '{}'", item.uid);
			});
		} catch (Exception e) {
			logger.error("Error while restoring webappdata", e);
			restorableItem.errors().add(DPError.restore(e.getMessage(), restorableItem.entryUid(), DPKind.WEBAPPDATA));
		} finally {
			restorableItem.endTask();
		}
	}
}
