/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.service.internal;

import java.util.ArrayList;
import java.util.List;

import com.google.common.base.MoreObjects;

public class MailboxIndexJson {
	public String filename;
	public String mailboxUid;
	public String domainUid;
	public String zipFileName;
	public List<String> filenames;

	public MailboxIndexJson() {
	}

	public MailboxIndexJson(String filename, String mailboxUid) {
		this.filename = filename;
		this.mailboxUid = mailboxUid;
		this.filenames = new ArrayList<>();
	}

	public MailboxIndexJson(String filename, String mailboxUid, String domainUid) {
		this(filename, mailboxUid);
		this.domainUid = domainUid;
	}

	public MailboxIndexJson(String filename, String mailboxUid, String domainUid, String zipFileName) {
		this(filename, mailboxUid, domainUid);
		this.zipFileName = zipFileName;
	}

	public MailboxIndexJson(List<String> filenames, String mailboxUid, String domainUid, String zipFileName) {
		this.filenames = filenames;
		this.mailboxUid = mailboxUid;
		this.domainUid = domainUid;
		this.zipFileName = zipFileName;
	}

	public String mailboxUid() {
		return mailboxUid;
	}

	public String filename() {
		return filename;
	}

	public List<String> filenames() {
		return filenames;
	}

	public String domainUid() {
		return domainUid;
	}

	public void domainUid(String domainUid) {
		this.domainUid = domainUid;
	}

	public String zipFileName() {
		return zipFileName;
	}

	public void zipFileName(String zipFileName) {
		this.zipFileName = zipFileName;
	}

	public void mailboxUid(String mailboxUid) {
		this.mailboxUid = mailboxUid;
	}

	public String containsFilename(String searchedFilename) {
		return filenames.stream().filter(f -> f.endsWith(searchedFilename)).findFirst().orElse(null);
	}

	public String toString() {
		return MoreObjects.toStringHelper(MailboxIndexJson.class).add("filename", this.filename())
				.add("zipFileName", this.zipFileName()).add("mailboxUid", mailboxUid).add("domainUid", domainUid)
				.toString();
	}

}
