/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.service.internal;

import java.util.ArrayList;

import net.bluemind.config.InstallationId;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.dataprotect.api.GenerationContent;
import net.bluemind.dataprotect.api.GenerationIndex;
import net.bluemind.dataprotect.api.WorkerDataType;
import net.bluemind.dataprotect.service.internal.IDirEntriesWorker.ParGenWorkerRecord;
import net.bluemind.domain.api.Domain;
import net.bluemind.server.api.IServer;
import net.bluemind.server.api.Server;

public class DirEntriesFactory {

	private IDirEntriesWorker worker;

	public DirEntriesFactory(ParGenWorkerRecord rec) {
		this.worker = rec.directory().getWorkerDataType() == WorkerDataType.DIRECTORY ? new DirEntriesJsonWorker(rec)
				: new DirEntriesPgWorker(rec);
	}

	public void loadGenerationContent(GenerationContent geneneration) {
		geneneration.domains = new ArrayList<ItemValue<Domain>>();
		geneneration.entries = new ArrayList<GenerationIndex>();

		IServiceProvider provider = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM);
		IServer serverApi = provider.instance(IServer.class, InstallationId.getIdentifier());
		ItemValue<Server> serverItem = serverApi.getComplete(worker.getPartGenRecord().directory().server);
		String serverIp = serverItem.value.ip;

		worker.loadContent(serverIp, geneneration);
	}
}
