/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2023
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.resource.impl.pg;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.dataprotect.api.DPError;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.common.restore.IMonitoredRestoreRestorableItem;
import net.bluemind.dataprotect.resource.impl.ResourceRestoreWorker;
import net.bluemind.dataprotect.service.BackupDataProvider;
import net.bluemind.resource.api.IResources;
import net.bluemind.resource.api.ResourceDescriptor;

public class RestoreResourceTaskPg {

	private static final Logger logger = LoggerFactory.getLogger(RestoreResourceTaskPg.class);

	private final DataProtectGeneration backup;
	private IMonitoredRestoreRestorableItem restorableItem;
	protected final ResourceRestoreWorker resourceWorker;

	/**
	 * @deprecated REMOVE THIS IN BlueMind 6+
	 */
	@Deprecated
	public RestoreResourceTaskPg(DataProtectGeneration backup, IMonitoredRestoreRestorableItem item,
			ResourceRestoreWorker resourceWorker) {
		this.backup = backup;
		this.restorableItem = item;
		this.resourceWorker = resourceWorker;
	}

	public void run() {
		logger.info("Restoring resource {}:{}", restorableItem.entryUid(), restorableItem.displayName());

		try (BackupDataProvider bdp = new BackupDataProvider(null, SecurityContext.SYSTEM,
				restorableItem.getMonitor())) {
			BmContext backupContext = bdp.createContextWithData(backup, restorableItem.item());
			IServiceProvider back = backupContext.provider();

			ItemValue<ResourceDescriptor> backupResource = back.instance(IResources.class, restorableItem.domain())
					.getComplete(restorableItem.entryUid());
			ItemValue<ResourceDescriptor> liveResource = resourceWorker.createOrUpdateLiveEntry(backupResource);
			restorableItem.setLiveEntryUid(liveResource.uid);
			resourceWorker.restoreEntryDependantContainers();

			restorableItem.monitorLog("resource {}: {} restored", restorableItem.entryUid(),
					restorableItem.displayName());

		} catch (Exception e) {
			logger.error("Error while restoring resource", e);
			restorableItem.errors()
					.add(DPError.restore(e.getMessage(), restorableItem.entryUid(), DPError.DPKind.RESOURCE));
		} finally {
			restorableItem.endTask();
		}
	}

}
