/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2023
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.resource;

import java.util.Arrays;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.core.task.api.TaskRef;
import net.bluemind.core.task.service.ITasksManager;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.api.Restorable;
import net.bluemind.dataprotect.api.RestorableKind;
import net.bluemind.dataprotect.api.RestoreOperation;
import net.bluemind.dataprotect.resource.impl.RestoreResourceTask;
import net.bluemind.dataprotect.service.IRestoreActionProvider;
import net.bluemind.dataprotect.service.action.IRestoreActionData;
import net.bluemind.dataprotect.service.action.RestoreActionExecutor;

public class RestoreResource implements IRestoreActionProvider {

	private static final Logger logger = LoggerFactory.getLogger(RestoreResource.class);

	public RestoreResource() {
	}

	@Override
	public TaskRef run(final RestoreOperation op, final DataProtectGeneration backup, final Restorable item,
			RestoreActionExecutor<? extends IRestoreActionData> executor) throws ServerFault {
		logger.info("Restoring resource {}:{}@{}", item.entryUid, item.displayName, item.domainUid);
		ITasksManager tsk = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM).instance(ITasksManager.class);
		return tsk.run(new RestoreResourceTask(backup, item));
	}

	@Override
	public List<RestoreOperation> operations() {
		return Arrays.asList(RestoreOperation
				.forKind("complete.restore." + RestorableKind.RESOURCE.name().toLowerCase(), RestorableKind.RESOURCE));

	}

}
