/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.dataprotect.mailbox.mailshare;

import java.util.List;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.task.service.IServerTask;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.api.Restorable;
import net.bluemind.dataprotect.api.RestorableKind;
import net.bluemind.dataprotect.api.RestoreOperation;
import net.bluemind.dataprotect.mailbox.AbstractRestoreActionProvider;
import net.bluemind.dataprotect.mailbox.MboxRestoreService.Mode;

public class MailshareRestoreActionProvider extends AbstractRestoreActionProvider {

	private static final String COMPLETE_IDENTIFIER = "complete.restore."
			+ RestorableKind.MAILSHARE.name().toLowerCase();

	public MailshareRestoreActionProvider() {
		super(RestorableKind.MAILSHARE);
	}

	@Override
	public List<RestoreOperation> operations() {
		List<RestoreOperation> operations = super.operations();

		RestoreOperation completeRestore = new RestoreOperation();
		completeRestore.identifier = COMPLETE_IDENTIFIER;
		completeRestore.kind = RestorableKind.MAILSHARE;
		operations.add(completeRestore);

		return operations;
	}

	@Override
	public IServerTask getRestoreTask(RestoreOperation op, DataProtectGeneration backup, Restorable item) {
		if (RESTORE_REPLACE_IDENTIFIER.equals(op.identifier)) {
			return new RestoreMailshareTask(backup, item, Mode.REPLACE);
		}

		if (RESTORE_SUBFOLDER_IDENTIFIER.equals(op.identifier) || COMPLETE_IDENTIFIER.equals(op.identifier)) {
			return new RestoreMailshareTask(backup, item, Mode.SUBFOLDER);
		}

		throw new ServerFault("Unsupported op identifier: " + op.identifier);
	}

}
