/* BEGIN LICENSE
  *
  * Copyright © Blue Mind SAS, 2012-2025
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.mailbox.deserializer;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import net.bluemind.tag.api.Tag;

public class CyrusSdsBackupTag {

	private Tag tag;

	public CyrusSdsBackupTag(Tag tag) {
		this.tag = tag;
	}

	public Tag tag() {
		return tag;
	}

	public static CyrusSdsBackupTag from(JsonParser parser) throws IOException {
		if (parser.currentToken() != JsonToken.START_OBJECT) {
			throw new IllegalStateException("Expected an object");
		}
		Tag parsedTag = new Tag();

		JsonToken tok;
		while ((tok = parser.nextToken()) != JsonToken.END_OBJECT && tok != null) {
			String fieldName = parser.currentName();
			switch (fieldName) {
			case "color":
				parsedTag.color = parser.nextTextValue();
				break;
			case "label":
				parsedTag.label = parser.nextTextValue();
				break;
			default:
				break;
			}

		}
		return new CyrusSdsBackupTag(parsedTag);
	}

}