/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.mailbox.backup;

import java.util.List;
import java.util.Map;

import net.bluemind.core.container.model.ItemValue;
import net.bluemind.dataprotect.sdsspool.SdsDataProtectSpool;
import net.bluemind.dataprotect.service.internal.CommonBackupWorker.MailboxIndexJsonList;
import net.bluemind.dataprotect.service.internal.MailboxIndexJson;
import net.bluemind.directory.api.DirEntry;
import net.bluemind.domain.api.Domain;
import net.bluemind.sds.store.ISdsSyncStore;

public interface IMailboxBackupWorker {
	public MailboxIndexJson backupSdsMailbox(DirEntry de, ItemValue<Domain> domain, boolean downloadEmailContent);

	public String getZipFileName();

	public void setProductionStores(Map<String, ISdsSyncStore> productionStores);

	public void setBackupStore(SdsDataProtectSpool backupStore);

	public MailboxIndexJsonList runIt(ItemValue<Domain> domain, List<String> values, boolean downloadEmailContent);

}
