/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2021
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.mailbox.deserializer;

import java.io.IOException;
import java.nio.file.Path;

import net.bluemind.dataprotect.common.backup.RepositoryBackupPath;
import net.bluemind.dataprotect.service.internal.CommonBackupWorker.MailboxIndexJsonList;
import net.bluemind.dataprotect.service.internal.MailboxIndexJson;

public class CyrusSdsIndexReader {
	private MailboxIndexJsonList sdsIndexContent;

	public CyrusSdsIndexReader(Path indexPath) throws IOException {
		sdsIndexContent = RepositoryBackupPath.readIndexFile(indexPath);
	}

	public MailboxIndexJson getMailbox(String mailboxUid) {
		if (sdsIndexContent == null) {
			return null;
		}
		return sdsIndexContent.mailboxesIndexInfo().stream().filter(m -> m.mailboxUid().equalsIgnoreCase(mailboxUid))
				.findFirst().orElse(null);
	}
}