package net.bluemind.dataprotect.mailbox;

import java.util.ArrayList;
import java.util.List;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.core.task.api.TaskRef;
import net.bluemind.core.task.service.IServerTask;
import net.bluemind.core.task.service.ITasksManager;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.api.Restorable;
import net.bluemind.dataprotect.api.RestorableKind;
import net.bluemind.dataprotect.api.RestoreOperation;
import net.bluemind.dataprotect.service.IRestoreActionProvider;
import net.bluemind.dataprotect.service.action.IRestoreActionData;
import net.bluemind.dataprotect.service.action.RestoreActionExecutor;
import net.bluemind.server.api.TagDescriptor;

public abstract class AbstractRestoreActionProvider implements IRestoreActionProvider {

	private final RestorableKind kind;

	public static final String RESTORE_REPLACE_IDENTIFIER = "replace.mailbox";
	public static final String RESTORE_SUBFOLDER_IDENTIFIER = "subfolder.mailbox";

	protected AbstractRestoreActionProvider(RestorableKind kind) {
		this.kind = kind;
	}

	@Override
	public TaskRef run(RestoreOperation op, DataProtectGeneration backup, Restorable item,
			RestoreActionExecutor<? extends IRestoreActionData> executor) throws ServerFault {

		ITasksManager tsk = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM).instance(ITasksManager.class);
		IServerTask toRun = getRestoreTask(op, backup, item);
		return tsk.run(toRun);
	}

	@Override
	public List<RestoreOperation> operations() {
		List<RestoreOperation> operations = new ArrayList<>();
		operations.add(RestoreOperation.forKind(RESTORE_REPLACE_IDENTIFIER, kind, TagDescriptor.mail_imap.getTag()));
		operations.add(RestoreOperation.forKind(RESTORE_SUBFOLDER_IDENTIFIER, kind));
		return operations;
	}

	protected IServerTask getRestoreTask(RestoreOperation op, DataProtectGeneration backup, Restorable item) {
		throw new UnsupportedOperationException("Method can only be called on an instance capable of restore");
	}

}
