/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.mailbox.backup;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.config.Token;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.dataprotect.api.IDPContext;
import net.bluemind.dataprotect.api.PartGeneration;
import net.bluemind.dataprotect.mailbox.deserializer.RestoreSdsMailbox;
import net.bluemind.dataprotect.sdsspool.SdsDataProtectSpool;
import net.bluemind.domain.api.Domain;
import net.bluemind.sds.store.ISdsSyncStore;
import net.bluemind.serviceprovider.SPResolver;
import net.bluemind.system.api.ISystemConfiguration;
import net.bluemind.system.api.SystemConf;
import net.bluemind.tag.api.Tag;

public class MailBackupWorker {

	protected IDPContext ctx;

	protected static Logger logger = LoggerFactory.getLogger(MailBackupWorker.class);
	protected final Path workingFolder;
	protected final Path jsonIndex;
	protected final RestoreSdsMailbox lastBackup;
	protected final IServiceProvider serviceProvider;
	protected final PartGeneration partGen;

	protected SystemConf sysconf;

	protected Map<String, ISdsSyncStore> productionStores = new HashMap<>();
	protected SdsDataProtectSpool backupStore = null;

	protected boolean downloadEmailContent;
	protected ItemValue<Domain> domain;

	public MailBackupWorker(IDPContext ctx, Path workingFolder, Path jsonIndex, RestoreSdsMailbox lastBackup,
			PartGeneration partGen) {
		this.ctx = ctx;
		this.workingFolder = workingFolder;
		this.jsonIndex = jsonIndex;
		this.lastBackup = lastBackup;
		this.partGen = partGen;
		this.serviceProvider = SPResolver.get().resolve(Token.admin0());
		this.sysconf = serviceProvider.instance(ISystemConfiguration.class).getValues();
	}

	protected void logError(Throwable throwable) {
		if (partGen != null) {
			partGen.withWarnings = true;
		}
		ctx.error(throwable, throwable.getMessage());
	}

	protected void logError(Exception ex, String message, Object... args) {
		if (partGen != null) {
			partGen.withWarnings = true;
		}
		ctx.error(ex, message, args);
	}

	public void setProductionStores(Map<String, ISdsSyncStore> productionStores) {
		this.productionStores = productionStores;
	}

	public void setBackupStore(SdsDataProtectSpool backupStore) {
		this.backupStore = backupStore;
	}
}
