/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.directory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.bluemind.core.container.api.ContainerSubscriptionDescriptor;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.dataprotect.api.GenerationIndex;
import net.bluemind.dataprotect.common.backup.RestorableDirEntry;
import net.bluemind.device.api.Device;
import net.bluemind.directory.api.DirEntry;
import net.bluemind.group.api.Group;
import net.bluemind.mailbox.api.MailFilter;
import net.bluemind.mailbox.identity.api.IdentityDescription;
import net.bluemind.system.api.Credential;
import net.bluemind.tag.api.Tag;
import net.bluemind.user.api.User;

public class RestorableUser extends RestorableDirEntry<User> {

	public Map<String, String> settings = new HashMap<>();
	public List<ItemValue<Tag>> tags;
	public List<IdentityDescription> identities;
	public List<ItemValue<Group>> memberOf;
	public MailFilter filter;

	public List<ContainerSubscriptionDescriptor> subscriptions;
	public List<ItemValue<Device>> devices;
	public List<Credential> credentials;

	public RestorableUser() {
		super();
	}

	public RestorableUser(ItemValue<DirEntry> dirEntry, ItemValue<User> item) {
		super(dirEntry, item);
	}

	@Override
	public GenerationIndex fromRestorable() {
		return new GenerationIndex(dirEntry.uid, dirEntry.displayName, dirEntry.value.email, dirEntry.value.path,
				dirEntry.value.kind, dirEntry.value.dataLocation);
	}

}
