/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.calendar.impl.user;

import java.util.List;

import net.bluemind.calendar.api.CalendarDescriptor;
import net.bluemind.calendar.api.ICalendarsMgmt;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.api.IContainers;
import net.bluemind.core.container.model.BaseContainerDescriptor;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.common.restore.IMonitoredRestoreRestorableItem;
import net.bluemind.dataprotect.common.restore.directory.RestoreDirWorker;

public class RestoreUserCalendarsWorker extends RestoreDirWorker<CalendarDescriptor> {

	public RestoreUserCalendarsWorker(DataProtectGeneration backup, IMonitoredRestoreRestorableItem restorableItem) {
		super(backup, restorableItem);
	}

	@Override
	public ItemValue<CalendarDescriptor> createOrUpdateLiveEntry(ItemValue<CalendarDescriptor> backupResource)
			throws InterruptedException {

		BmContext live = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM).getContext();
		ICalendarsMgmt serviceLive = live.provider().instance(ICalendarsMgmt.class);

		CalendarDescriptor liveEntry = serviceLive.getComplete(backupResource.uid);
		if (liveEntry != null) {
			serviceLive.update(backupResource.uid, backupResource.value);
			return ItemValue.create(backupResource.uid, liveEntry);
		}

		List<BaseContainerDescriptor> calendarsList = live.provider().instance(IContainers.class)
				.allLight(backupResource.value.asContainerQuery());
		if (calendarsList.size() > 1) {
			throw new ServerFault(
					String.format("More than one domain calendar named '%s' found", backupResource.value.name));
		}
		calendarsList.stream().filter(c -> c != null).forEach(c -> serviceLive.delete(c.uid));

		serviceLive.create(backupResource.uid, backupResource.value);
		liveEntry = serviceLive.getComplete(backupResource.uid);
		return ItemValue.create(backupResource.uid, liveEntry);
	}

	@Override
	public void restoreEntryDependantContainers() {
	}
}
