/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.addressbook.impl.pg;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.addressbook.api.AddressBookDescriptor;
import net.bluemind.addressbook.api.IAddressBook;
import net.bluemind.addressbook.api.IAddressBooksMgmt;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.dataprotect.addressbook.impl.CommonRestoreBooks;
import net.bluemind.dataprotect.addressbook.impl.domain.RestoreDomainBooksWorker;
import net.bluemind.dataprotect.api.DPError;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.common.restore.IMonitoredRestoreRestorableItem;
import net.bluemind.dataprotect.service.BackupDataProvider;

public class RestoreDomainBooksTaskPg {
	private static final Logger logger = LoggerFactory.getLogger(RestoreDomainBooksTaskPg.class);
	private IMonitoredRestoreRestorableItem restorableItem;
	private DataProtectGeneration backup;
	private RestoreDomainBooksWorker domainBooksWorker;

	/**
	 * @deprecated REMOVE THIS IN BlueMind 6+
	 */
	@Deprecated
	public RestoreDomainBooksTaskPg(DataProtectGeneration backup, IMonitoredRestoreRestorableItem restorableItem,
			RestoreDomainBooksWorker domainBooksWorker) {
		this.backup = backup;
		this.restorableItem = restorableItem;
		this.domainBooksWorker = domainBooksWorker;
	}

	public void run() {
		try (BackupDataProvider bdp = new BackupDataProvider(null, SecurityContext.SYSTEM,
				restorableItem.getMonitor())) {
			BmContext back = bdp.createContextWithData(backup, restorableItem.item());
			BmContext live = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM).getContext();

			AddressBookDescriptor backDomainAddressBook = back.provider().instance(IAddressBooksMgmt.class)
					.get(restorableItem.entryUid());

			List<String> allUids = back.provider().instance(IAddressBook.class, restorableItem.entryUid()).allUids();
			restorableItem.monitorLog("Restoring '{}' contacts from {} [uid={}]", allUids.size(),
					backDomainAddressBook.name, restorableItem.entryUid());

			domainBooksWorker
					.createOrUpdateLiveEntry(ItemValue.create(restorableItem.entryUid(), backDomainAddressBook));

			new CommonRestoreBooks(restorableItem, back, live).restoreEntities(allUids);

		} catch (Exception e) {
			logger.error("Error while restoring domain addressbook {}@{}: {}", restorableItem.entryUid(),
					restorableItem.domain(), e.getMessage());
			restorableItem.errors()
					.add(DPError.restore(e.getMessage(), restorableItem.entryUid(), DPError.DPKind.DOMAIN_ADDRESSBOOK));
		} finally {
			restorableItem.endTask();
		}
	}
}
