/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.cti.api.IComputerTelephonyIntegration.
 */

goog.provide('net.bluemind.cti.api.ComputerTelephonyIntegrationVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.cti.api.IComputerTelephonyIntegration API.
 * @param {string sessionId} sessionId
*  @param {string} domainUid
*  @param {string} userUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationVertxClient = function( sessionId , domainUid , userUid ) {
  this.sessionId = sessionId;
  this.base = '/cti/{domainUid}/{userUid}';
  this.domainUid_ = domainUid;
  this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
  this.userUid_ = userUid;
  this.base = this.base.replace('{userUid}',goog.string.urlEncode(userUid));
};

goog.inherits(net.bluemind.cti.api.ComputerTelephonyIntegrationVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationVertxClient.prototype.domainUid_;
/**
 * @type {string} userUid
 * @private
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationVertxClient.prototype.userUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} number
 * @return {Object}
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationVertxClient.prototype.dial = function( number  ) {

  var postUri = "/dial";

  var params = {};

  if (goog.isDefAndNotNull(number)) {
    params['number'] = number;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} component
 * @param {string} phoneNumber
 * @return {Object}
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationVertxClient.prototype.forward = function( component ,  phoneNumber  ) {

  var postUri = "/forward/{component}";

  postUri = postUri.replace("{component}", goog.string.urlEncode(component));
  var params = {};

  if (goog.isDefAndNotNull(phoneNumber)) {
    params['phoneNumber'] = phoneNumber;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationVertxClient.prototype.getStatus = function() {

  var postUri = "/status";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationVertxClient.prototype.getUserEmails = function() {

  var postUri = "/users";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} component
 * @param {Object} status
 * @return {Object}
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationVertxClient.prototype.setStatus = function( component ,  status  ) {

  var postUri = "/status/{component}";

  postUri = postUri.replace("{component}", goog.string.urlEncode(component));
  var params = {};



  var body = null;
  body = status;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

