/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.cti.api.IComputerTelephonyIntegration.
 */

goog.provide('net.bluemind.cti.api.ComputerTelephonyIntegrationClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.cti.api.IComputerTelephonyIntegration API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} domainUid
*  @param {string} userUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationClient = function(rpc, base , domainUid , userUid ) {
  goog.base(this, rpc, base);
  this.base += '/cti/{domainUid}/{userUid}';
   this.domainUid_ = domainUid;
   this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
   this.userUid_ = userUid;
   this.base = this.base.replace('{userUid}',goog.string.urlEncode(userUid));
};

goog.inherits(net.bluemind.cti.api.ComputerTelephonyIntegrationClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationClient.prototype.domainUid_;
/**
 * @type {string} userUid
 * @private
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationClient.prototype.userUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} number
 * @return {Object}
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationClient.prototype.dial = function( number  ) {

  var postUri = "/dial";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(number)) {
    url.getQueryData().add('number', number);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "dial_" 
                                  + this.domainUid_
                                  + this.userUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} component
 * @param {string} phoneNumber
 * @return {Object}
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationClient.prototype.forward = function( component ,  phoneNumber  ) {

  var postUri = "/forward/{component}";

  postUri = postUri.replace("{component}", goog.string.urlEncode(component));

  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(phoneNumber)) {
    url.getQueryData().add('phoneNumber', phoneNumber);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "forward_" 
                                  + this.domainUid_
                                  + this.userUid_
                                  + component
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationClient.prototype.getStatus = function() {

  var postUri = "/status";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getStatus_" 
                                  + this.domainUid_
                                  + this.userUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationClient.prototype.getUserEmails = function() {

  var postUri = "/users";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getUserEmails_" 
                                  + this.domainUid_
                                  + this.userUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} component
 * @param {Object} status
 * @return {Object}
 */
net.bluemind.cti.api.ComputerTelephonyIntegrationClient.prototype.setStatus = function( component ,  status  ) {

  var postUri = "/status/{component}";

  postUri = postUri.replace("{component}", goog.string.urlEncode(component));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setStatus_" 
                                  + this.domainUid_
                                  + this.userUid_
                                  + component
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = status;
  return this.execute(cmd, body);
};

